<?php


namespace Modules\ZSearch\Models;

use Illuminate\Database\Eloquent\Model;

class Filter extends Model
{
    protected $table = 'filter';

    protected $fillable = [
        'name',
        'display_name',
        'slug',
    ];

    public function values()
    {
        return $this->hasMany(FilterValue::class, 'filter_id', 'id')->orderBy('id');
    }

    public function productCount()
    {
        return $this->values()->countProduct();
    }

    public function categories(){
        return $this->belongsToMany(Category::class, 'filter_n_category');
    }

}
