<?php

namespace Modules\ZSearch\Models;

use Illuminate\Database\Eloquent\Model;

class FilterValue extends Model
{
    protected $table = 'filter_value';

    protected $fillable = [
        'filter_id',
        'name',
        'slug',
    ];

    public function products()
    {
        return $this->belongsToMany(Product::class, 'filter_value_n_product');
    }

    public function countProduct()
    {
        return $this->products()->selectRaw('count(sb_product.id) as aggregate')
        ->groupBy('pivot_product_id');
    }

    public function filter () {
        return $this->belongsTo(Filter::class, 'filter_id');
    }
}
