<?php

namespace Modules\ZSearch\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;

class Option extends Model {

    protected $table = "option";

    protected $fillable = ['key', 'value'];
    public $timestamps = false;
    static $cache = [];


    public static function getStartId($key) {
        $result = 0;
        $item =  DB::table('option')
            ->where('key', $key)
            ->first();
        if (isset($item->id)) {
            $data = json_decode($item->value);
            $result = isset($data->id) ? $data->id : 0;
        }
        return $result;
    }

    public static function setStartId($key, $id) {
        $data = [
            'id' => $id,
            'date' => date('Y-m-d H:i:s', time())
        ];
        self::setOption($key, json_encode($data));
    }


    public static function setOption($key, $data) {
        $item = DB::table('option')
            ->where('key', $key)
            ->first();
        if (isset($item->id)) {
            DB::table('option')
                ->where('id', $item->id)
                ->update([
                    'value' => $data
                ]);
        } else {
            DB::table('option')->insert([
                'value' => $data,
                'key' => $key,
            ]);
        }
    }

    public static function getOption($key, $default = false){
        $cacheKey = env('APP_LOCALE') . '_option_' . $key;

        if (isset($_SERVER['HTTP_HOST']) && env('CACHE_BY_DOMAIN', false)) {
            $cacheKey .= "::" . $_SERVER['HTTP_HOST'];
        }

        if (array_key_exists($cacheKey, self::$cache)) {
            return self::$cache[$cacheKey];
        }


        if (Cache::has($cacheKey)) {
            self::$cache[$cacheKey] = Cache::get($cacheKey);
            return self::$cache[$cacheKey];
        }

        $result = $default;
        $option = DB::table('option')->where('key', $key)->first(['value', 'type']);
        if ($option && isset($option->value) && $option->value) {
            $firstChar = isset($option->value[0]) ? $option->value[0] : '';
            if ($option->type == 'json' || in_array($firstChar, ['[', '{'])) {
                $result = json_decode($option->value);
            }  else {
                $result = $option->value;
            }

        }
        self::$cache[$cacheKey] = $result;
        Cache::put($cacheKey, $result, 5);

        return $result;
    }
}
