<?php

namespace App\Modules\ZSearch\Models;
use Illuminate\Support\Facades\Schema;

use Illuminate\Database\Eloquent\Model;

class ProductFeatureTag extends Model {
    protected $table = "product_feature_tag";
    public $timestamps = true;
    static $cache = [];
    public static function getByProduct($productId) {
        $result = null;
        if (self::tableExists()) {
            $result = self::where('product_id', $productId)->first([
                'tag_id as id',
                'tag_title as title',
                'tag_slug as slug',
            ]);
        }
        return $result;
    }

    public static function tableExists() {
        $table = 'product_feature_tag';
        if (!array_key_exists($table, self::$cache)) {
            self::$cache[$table] = Schema::hasTable($table);
        }
        return array_key_exists($table, self::$cache) ? self::$cache[$table] : false;
    }

}