<?php

namespace App\Modules\ZSearch\Models;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Eloquent\Model;

class ProductMeta extends Model
{
    // public $timestamps = false;
    protected $table = 'product_meta';

    protected $fillable = [
        'product_id',
        'key',
        'value',
    ];

    public static function createOrUpdate($productId, $key, $value) {
        if (self::tableExists()) {
            DB::table('product_meta')
                ->where('product_id', $productId)
                ->where('key', $key)
                ->delete();

            DB::table('product_meta')->insert([
                'product_id' => $productId,
                'key' => $key,
                'value' => $value
            ]);
        }
    }

    public static function tableExists() {
        return Schema::hasTable('product_meta');
    }

}
