<?php

namespace Modules\ZSearch\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Modules\ZSearch\Models\Traits\BaseTrait;

class SearchReact extends Model {

    use BaseTrait;
    protected $table = "search_react";
    protected $fillable = [
        'keyword', 'date', 'click', 'conversion', 'product_id'
    ];

    static $operationFilter = [
        'eq' => [
            'product_id',
            'keyword',
            'date',
        ],
        //>
        'gt' => [
        ],
        // >=
        'gte' => [
            [
                'filter' => 'date_gte',
                'column' => 'date',
            ]
        ],
        //<
        'lt' => [],
        // <=
        'lte' => [
            [
                'filter' => 'date_lte',
                'column' => 'date',
            ],
        ],
        //!=
        'ne' => [
        ],
        //not in
        'nin' => [
        ],
        //in
        'in' => [
        ],
        'like' => []
    ];


    public static function createOrUpdateSearchReact($item) {
        $isExists = self::query()
            ->where('keyword', $item['keyword'])
            ->where('product_id', $item['product_id'])
            ->where('date', $item['date'])
            ->exists();
        if ($isExists) {
            self::query()
                ->where('keyword', $item['keyword'])
                ->where('date', $item['date'])
                ->where('product_id', $item['product_id'])
                ->update($item);
        } else {
            self::query()
                ->where('keyword', $item['keyword'])
                ->where('product_id', $item['product_id'])
                ->where('date', $item['date'])
                ->create($item);
        }
    }



}
