<?php

namespace Modules\ZSearch\Models\Traits;


trait CustomAppend
{

    public static $withoutAppends = false;
    public static $customAppends = [];


    /**
     * Check if $withoutAppends is enabled.
     *
     * @return array
     */
    protected function getArrayableAppends()
    {
        if(self::$withoutAppends){
            return [];
        }
        if(self::$customAppends){
            return array_combine(self::$customAppends, self::$customAppends);
        }
        if (isset($GLOBALS['setGlobalDisableAppendModel'])) {
            return [];
        }

        return parent::getArrayableAppends();
    }

    public static function setCustomAppend($appends) {
        self::$customAppends = $appends;
    }

    public function scopeWithoutAppends($query)
    {
        self::$withoutAppends = true;
    
        return $query;
    }
}
