system.controller('ZSearchProductDuplicateWarning', ZSearchProductDuplicateWarning);

function ZSearchProductDuplicateWarning($rootScope, $scope, $http, $q, $window) {
    
    $scope.terms;
    $scope.failMessage;
    $scope.isChecking = false;
    $scope.isComplete = false;
    $scope.matchs = [];
    $scope.notMatchs = [];
    $scope.items = [];
    $scope.mode = 'config';
    const ERROR_MESSAGE = 'Có lỗi xảy ra trong quá trình kiểm tra. Hãy liên hệ với bộ phận kỹ thuật để được hỗ trợ.';
    const INPROCESS_MESSAGE = 'Quá trình kiểm tra đang diễn ra, xin vui lòng chờ trong giây lát.';
    const CONFIG_KEY = 'keywords_duplicate_images';
    

    $scope.checkTerms = function ($event) {
        if ($event.keyCode == 13 || $event.which == 13) {
            $scope.scan();
        }
    }

    $scope.openConfig = function () {
        if (CURRENT_LOCALE) {
            $window.open('/' + CURRENT_LOCALE + '/module/option-editor?key=' + CONFIG_KEY, '_blank');
        } else {
            $window.open('/module/option-editor?key=' + CONFIG_KEY, '_blank');
        }
    }

    $scope.init = function () {
        $http.get(base_api_url + '/keyword_duplicate_images', { params: { sorts: 'id', simple_paginate: 1 } }).then(function (response) {
            if (response.data && response.data.result) {
                var items = {}; 
                response.data.result.forEach(function (item) {
                    items[item.keyword] = JSON.parse(item.content);
                })
                $scope.items = items;
                $scope.isComplete = true;
                $scope.isChecking = false;
                $scope.failMessage = null;
            }
        }, function (error) {
            $scope.failMessage = 'Có lỗi xảy ra trong quá trình lấy danh sách từ khóa.';
            return;
        });
    }
    
    $scope.scan = function () {
        if ($scope.isChecking) return;

        if (!$scope.terms) {
            $scope.failMessage = 'Mời nhập một từ khóa để kiểm tra.';
            return;
        }

        $scope.mode = 'single';
        $scope.keywords = [];
        $scope.isComplete = false;
        $scope.isChecking = true;
        $scope.failMessage = INPROCESS_MESSAGE
        $('#btn-scan').button('loading');
        $http.get(SEARCH_API_URL, { params: { q: $scope.terms, page_id: 0, page_size: 15 } }).then(function (response) {
            var result = response.data.result || {};
            $scope.items = [];
            if (response.data.status == 'successful' && result.products && result.products.length != 0) {
                $scope.validateImages($scope.buildProductData(result.products));
            } else {
                $('#btn-scan').button('reset');
                $scope.failMessage = 'Không tìm thấy dữ liệu cho từ khóa này.';
                $scope.isChecking = false;
            }
        }, function (error) {
            $scope.isChecking = false;
            $scope.failMessage = ERROR_MESSAGE;
        });
    }

    $scope.buildProductData = function(products) {
        return products.map(function (product) {
            return {
                id: product.id,
                image_url: product.image_url,
                url: product.url,
                name: product.name,
                display_high_price: product.display_high_price,
                display_price: product.display_price,
                percent_sale: product.percent_sale
            };
        });
    }

    $scope.validateImages = function (products) {
        $http.post(CHECK_IMAGE_URL, { element: products }).then(function (response) {
            $scope.isComplete = true;
            $scope.isChecking = false;
            $scope.matchs = response.data.matchs || [];
            $scope.notMatchs = response.data.not_matchs || [];
            $scope.failMessage = null;
            $('#btn-scan').button('reset');
        }, function (error) {
            $('#btn-scan').button('reset');
            $scope.isComplete = true;
            $scope.isChecking = false;
            $scope.failMessage = ERROR_MESSAGE;
        });
    }

    $scope.init();

}