system.controller('ZSearchProductPined', ZSearchProductPined);


function ZSearchProductPined($rootScope, $scope, $http) {
    $scope.products = [];
    $scope.suggestItems = [];
    $scope.buildData = [];
    $scope.filter = {
        pageId: 0,
        pageSize: 0,
    };
    $scope.isLoadingProduct = false;
    $scope.isSearch = false;
    $scope.search = '';
    $scope.order = null;
    $scope.product = {};
    var suggestProductFlag;

    this.initialize = function() {
        $scope.find();
    }

    /**
     * find data by filter
     * @returns {undefined}
     */
    $scope.find = function () {
        var url = base_api_url + '/product_pined'
        $scope.isLoadingProduct = true;
        $http.get(url, {
            params: {
                pageId: $scope.filter.page_id,
                pageSize: 500,
                sorts: 'id'
            }
        }).then(function (result) {
            let data = result.data;
            if (data && data.result) {
                let items = buildData(data.result)
                $scope.filter.meta = data.meta;
                decorProduct(items);

            }
        }).catch(function () {
            alert('Không thể tải danh sách, vui lòng thử lại hoặc liên hệ bộ phận kỹ thuật để được hỗ trợ.');
            $scope.isLoadingProduct = false;
        });

    };

    $scope.deleteProductPined = function(product) {
        var url = base_api_url + '/product_pined/' + product.id;
        var r = confirm('Bạn chắc chắn muốn xóa sản phẩm ' + product.name);
        if (r == true) {
            $http.delete(url).then(function (result) {
                $scope.find();
            })
        }
    }
    $scope.suggest = function() {
        $scope.productError = '';
        clearTimeout(suggestProductFlag);
        suggestProductFlag = setTimeout(function(){
            searchProduct();
        },400)
    }

    $scope.clearSuggest = function () {
        setTimeout(function() {
            $scope.$apply(function() {
                $scope.isSearch = false;
                $scope.suggestItems = [];
            });
        }, 300);

    }

    $scope.selectProduct = function(product) {
        if ($scope.buildData && $scope.buildData[product.id]) {
            $scope.productError = 'Sản phẩm ' + product.name + ' đã tồn tại';
        } else {
            $scope.productError = '';
            $scope.product = product;
            clearSuggest();
        }
        $scope.search = product.name;


    }



    $scope.savePined = function() {
        if ($scope.product) {
            let saveData = {
                product_id: $scope.product.id,
                order: $scope.order ? $scope.order : 0
            };
            var url = base_api_url + '/product_pined';
            $http.post(url, saveData).then(function (response) {
                if (response.data.status == 'successful') {
                }
                clearAfterSavePined();
                clearSuggest();
                $scope.find();
            }).catch(function () {
                $scope.isSearch = false;
            });
        }

    }

    $scope.editPined = function(item) {
        if (item.order != item.order_show) {
            item.order = item.order_show;
            var url = base_api_url + '/product_pined/' + item.id;
            $http.put(url, {
                product_id: item.product_id,
                order: item.order,
            }).then(function (response) {
                let items =  $scope.products;
                if (items) {
                    items.sort(function(a, b) {
                        return b.order - a.order;
                    });
                }
                $scope.products = items;
                if (response.data.status == 'successful') {
                    //@todo on edit done
                }
            }).catch(function () {
            });
        }
    }

    function clearAfterSavePined() {
        clearSuggest();
        $scope.product = null;
        $scope.search = null;
        $scope.order = null;
        $scope.suggestItems = [];
    }


    function clearSuggest() {
        $scope.isSearch = false;
        $scope.suggestItems = [];
    }

    function searchProduct() {
        $scope.isSearch = true;
        if ($scope.search && $scope.search.length > 0) {
            let url = base_api_url + '/product?page_size=10&fields=id,sku,image_url,name&search=' + $scope.search;
            $http.get(url).then(function (response) {
                if (response.data.status == 'successful' && $scope.isSearch) {
                    $scope.suggestItems = response.data.result;
                }
                $scope.isSearch = false;
            }).catch(function () {
                $scope.isSearch = false;
            });
        }

    }


    function decorProduct(data) {
        var urlGetProduct = buildUrlGetProduct(data)
        $http.get(urlGetProduct).then(function (response) {
            if (response && response.data && response.data.result) {
               for (let item of response.data.result) {
                   let productId = item.id;
                   if (data[productId]) {
                       data[productId].sku = item.sku;
                       data[productId].name = item.name;
                       data[productId].image_url = item.image_url;
                       data[productId].url = item.url;
                   }
               }
                buildItems(data);
            }
        })
        return data;

    }

    function buildItems(data) {
        let items = [];
        for(let i in data) {
            data[i].order_show = data[i].order;
            items.push(data[i]);
        }
        if (items) {
            items.sort(function(a, b) {
                return b.order - a.order;
            });
        }
        $scope.products = items;
        $scope.buildData = data;
        $scope.isLoadingProduct = false;
    }

    function buildUrlGetProduct(data) {
        let ids = Object.keys(data);
        let url = base_api_url + '/product?filters=id={' + ids.join(';') +  '}&fields=id,sku,name,slug,image_url';
        return url;
    }

    function buildData(items) {
        var buildedData = {};
        if (items) {
            for (let item of items) {
                item.pin_id = item.id;
                item.order = item.order != null ? parseInt(item.order) : 0;
                buildedData[item.product_id] = item;
            }
        }
        return buildedData;
    }

    $scope.getImageCdn = function ($url, $width = 0, $height = 0, $fitIn = true) {
        // return 0;
        if (!$url) return "";
        if (typeof zSearchCdnIgnoreUrl !== 'undefined') {
            for (let item of cdnIgnoreUrl) {
                if ($url.includes(item)) {
                    return $url;
                }
            }
        }
        if (typeof zSearchCdnAllowUrl !== 'undefined') {
            let check = false;
            for (let item of cdnAllowUrl) {
                if ($url.includes(item)) {
                    check = true;
                    break;
                }
            }
            if (!check) {
                return $url;
            }
        }

        let retval;
        let originUrl = $url;
        if (originUrl.substr(0, 4) == 'http') {
            $url = $url.replace('https://', '');
            $url = $url.replace('http://', '');
        }
        if ($url.includes('?')) {
            $url = encodeURIComponent($url);
        }
        // return $url;

        retval =  baseCdnUrl + "/" + $url;

        if ($width == 0 && $height == 0) {
            retval =  baseCdnUrl + "/" + $url;
        } else if ($width == 0 || $height == 0) {
            retval = baseCdnUrl + "/" + $width + "x" + $height + "/" + $url;
        } else {
            retval = baseCdnUrl + "/" + $width + "x" + $height + "/filters:fill(fff)/" + $url;
        }
        return retval;
    }
    this.initialize();

}