system.controller('ZSearchTrackingReport', function ($scope, $rootScope, $http, $timeout) {
    
    $scope.pagesCount = 0;
    $scope.trackings = [];
    $scope.statistic = {};
    $scope.sorts = [
        { code: 'quantity-DESC', name: 'Số lượng giảm dần'},
        { code: 'quantity-ASC', name: 'Số lượng tăng dần'},
        { code: 'total_conversion-DESC', name: 'Chuyển đổi giảm dần'},
        { code: 'total_conversion-ASC', name: 'Chuyển đổi tăng dần'},
        { code: 'conversion_rate-DESC', name: 'Tỉ lệ chuyển đổi giảm dần'},
        { code: 'conversion_rate-ASC', name: 'Tỉ lệ chuyển đổi tăng dần'},
    ];

    $scope.defaultFilter = {
        pageId: 0,
        pageSize: 50,
        sortBy: $scope.sorts[0].code
    };

    $scope.filter = angular.copy($scope.defaultFilter);

    $scope.reset = function () {
        $scope.filter = angular.copy($scope.defaultFilter);
        $scope.init();
    }

    $scope.buildFilterData = function (validKeyword) {
        var dateFrom = $("#date-from").val();
        var dateTo = $("#date-to").val();
        if (validKeyword && (!$scope.filter.keyword || $scope.filter.keyword == '')) {
            toastr.error('Mời nhập từ khóa.');
            return false;
        }
        if (!dateFrom || dateFrom == '') {
            toastr.error('Mời chọn ngày bắt đầu Thống kê.');
            return false;
        }
        if (!dateTo || dateTo == '') {
            toastr.error('Mời chọn kết thúc Thống kê.');
            return false;
        }
        dateFrom = new Date(dateFrom);
        dateFrom.setHours(0, 0, 0, 0);
        dateTo = new Date(dateTo)
        dateTo.setHours(23, 59, 59, 0);

        if (dateFrom.getTime() >= dateTo.getTime()) {
            toastr.error('Ngày Bắt đầu thống kê phải nhỏ hơn ngày Kết thúc.');
            return false;
        }

        $scope.filter.dateFrom = dateFrom.getTime() / 1000;
        $scope.filter.dateTo = dateTo.getTime() / 1000;

        return angular.copy($scope.filter);
    }

    $scope.exportExcel = function() {
        var filter = $scope.buildFilterData();
        var url = prefixLocaleUrl + "z-search/tracking/export?dateFrom="+ filter.dateFrom;
        url += '&dateTo=' + filter.dateTo;
        url += '&sortBy=' + filter.sortBy;
        if (filter.keyword) {
            url += '&keyword=' + filter.keyword;
        }
        console.log(url);
        window.open(url, '_blank');
    }

    $scope.find = function () {
        var param = $scope.buildFilterData();
        if (param) {
            $http.get('/z-search/tracking/find', {params: param }).then(function (response) {
                if (response.data.status == "successful") {
                    $scope.trackings = response.data.data;
                    $scope.pageId = response.data.pageId;
                    $scope.pagesCount = response.data.pagesCount;
                } else {
                    $scope.trackings = [];
                }
            });
        }
    }

    $scope.enterEvent = function (event) {
        if (event.keyCode === 13 || event.which === 13) {
            $scope.pageId = 0;
            $scope.find();
        }
    }

    $scope.searchStatistic = function () {
        var filter = $scope.buildFilterData(true);
        if (filter) {
            var param = {
                keyword: filter.keyword,
                dateFrom: filter.dateFrom,
                dateTo: filter.dateTo
            };
            $scope.fetchStatistic('/z-search/report/statistic-search-data', param);
        }
    }

    $scope.statisticPrototype = function (item) {
        if (item.keyword && item.keyword != '') {
            var filter = $scope.buildFilterData();
            if (filter) {
                var param = {
                    keyword: item.keyword,
                    dateFrom: filter.dateFrom,
                    dateTo: filter.dateTo
                };
                $scope.fetchStatistic('/z-search/report/statistic', param);
            }
        }
    }

    $scope.fetchStatistic = function (url, param) {
        $scope.statistic = {};
        $http.get(url, { params: param }).then(function (response) {
            if (response.data.status == "successful" && response.data.data) {
                var rebuildStatistic = {};
                response.data.data.forEach(function (element) {
                    if (!rebuildStatistic[element.variant_name]) {
                        rebuildStatistic[element.variant_name] = [];
                    }
                    rebuildStatistic[element.variant_name].push({
                        "variant_option_name": element.variant_option_name,
                        "count" : element.count
                    });
                });
    
                $scope.statistic = {
                    keyword: param.keyword,
                    data: rebuildStatistic,
                    hasData: (Object.keys(rebuildStatistic).length > 0) ? true : false,
                    dateFrom: $("#date-from").val(),
                    dateTo: $("#date-to").val()
                };
    
                $timeout(function () {
                    $('#statistic-form').modal('show');
                });
            } else {
                toastr.error('Không tìm thấy dữ liệu thống kê của từ khóa này.');
            }
        }, function (error) {
            toastr.error('Có lỗi xảy ra trong quá trình thống kê Màu áo, hình dạng của từ khóa này.');
        });
    }

    $scope.init = function () {
        $timeout(function () {
            $("#date-from").datepicker({
                dateFormat: "yy-mm-dd",
            }).datepicker("setDate", "-1m");

            $("#date-to").datepicker({
                dateFormat: "yy-mm-dd",
            }).datepicker("setDate", "+0");

            $scope.find();
        });
    }

    $scope.init();
});