@extends('system.layout.main', [
'ngController' => 'ZSearchProductDuplicateWarning'
])
@section('title')
    <title>{{ $title }}</title>
@endsection

@section('css')
    <style media="screen">
        .heading {
            font-size: 22px;
            margin: 10px 0px 20px 0px;
        }
        .fail-message {
            font-size: 15px;
        }
        .input-group-custom {
            margin-top: 20px;
        }
        .btn-config {
            padding: 10px 16px; 
            font-size: 18px; 
            line-height: 1.3333333;
            border-radius: 6px;
        }
    </style>
@endsection

@section('content')

    <div class="content" style="min-height: 500px" ng-cloak>
        <h3 class="heading">{{ $title }}</h3>
        <div class="row">
            <div class="col-xs-12 col-sm-6 col-sm-offset-3">
                <div class="input-group input-group-lg input-group-custom">
                    <input type="text" class="form-control" placeholder="Mời nhập một từ khóa để kiểm tra..." ng-model="terms" ng-keypress="checkTerms($event)" ng-disabled="isChecking">
                    <span class="input-group-btn">
                        <button type="button" id="btn-scan" class="btn btn-primary btn-flat" ng-click="scan($event)" ng-disabled="isChecking" data-loading-text="<span class='fa fa-spinner fa-spin'></span> Loading..."> <i class="fa fa-barcode"></i> KIỂM TRA</button>
                    </span>
                </div>
                <p style="color: purple; cursor: pointer; margin-top: 5px; text-align: right" ng-click="openConfig()">Nhấn vào đây để cấu hình danh sách từ khóa.</p>
                <p class="text-red fail-message" ng-bind-html="failMessage || '&nbsp;'"></p>
            </div>
        </div>
        <div class="row" ng-if="isComplete && mode == 'single'">
            <div class="col-xs-12 col-sm-12">
                <div class="box box-danger">
                    <div class="box-header with-border">
                        <h3 class="box-title">Danh sách Sản phẩm trùng lặp</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <table class="table table-bordered table-border">
                            <tr>
                                <th style="width: 5%">#</th>
                                <th class="col-sm-1">ID</th>
                                <th class="col-sm-1">Image</th>
                                <th class="col-sm-6">Tên sản phẩm</th>
                                <th class="col-sm-1">Giá thị trường</th>
                                <th class="col-sm-1">Giá bán</th>
                            </tr>
                            <tr ng-repeat="item in matchs track by $index">
                                <td style="width: 5%">@{{ $index + 1 }}</td>
                                <td ng-bind="item.id"></td>
                                <td align="center">
                                    <img ng-src="@{{item.image_url}}" width="100" />
                                </td>
                                <td>
                                    <p ng-bind="item.sku"></p>
                                    <div style="display: block">
                                        <a ng-href="@{{item.url}}" target="_blank">@{{ item.name }}</a>
                                    </div>
                                </td>
                                <td ng-bind="item.display_high_price"></td>
                                <td ng-bind="item.display_price"></td>
                            </tr>
                            <tr ng-if="matchs.length == 0">
                                <td colspan="5">Không tìm thấy dữ liệu...</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="row" ng-if="isComplete && mode == 'single'">
            <div class="col-xs-12 col-sm-12">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title">Danh sách Sản phẩm không trùng lặp</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <table class="table table-bordered table-border">
                            <tr>
                                <th style="width: 5%">#</th>
                                <th class="col-sm-1">ID</th>
                                <th class="col-sm-1">Image</th>
                                <th class="col-sm-6">Tên sản phẩm</th>
                                <th class="col-sm-1">Giá thị trường</th>
                                <th class="col-sm-1">Giá bán</th>
                            </tr>
                            <tr ng-repeat="item in notMatchs track by $index">
                                <td>@{{ $index + 1 }}</td>
                                <td ng-bind="item.id"></td>
                                <td align="center">
                                    <img ng-src="@{{item.image_url}}" width="100" />
                                </td>
                                <td>
                                    <p ng-bind="item.sku"></p>
                                    <div style="display: block">
                                        <a ng-href="@{{item.url}}" target="_blank">@{{ item.name }}</a>
                                    </div>
                                </td>
                                <td ng-bind="item.display_high_price"></td>
                                <td ng-bind="item.display_price"></td>
                            </tr>
                            <tr ng-if="notMatchs.length == 0">
                                <td colspan="5">Không tìm thấy dữ liệu...</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div ng-if="isComplete && mode == 'config'">
            <div class="row" ng-repeat="(keyword, elements) in items" ng-if="elements.matchs && elements.matchs.length != 0">
                <div class="col-xs-12 col-sm-12">
                    <div class="box box-danger">
                        <div class="box-header with-border">
                            <h3 class="box-title">Danh sách Sản phẩm trùng lặp: @{{ keyword }}</h3>
                            <div class="box-tools pull-right">
                                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="box-body">
                            <table class="table table-bordered table-border">
                                <tr>
                                    <th style="width: 5%">#</th>
                                    <th class="col-sm-1">ID</th>
                                    <th class="col-sm-1">Image</th>
                                    <th class="col-sm-6">Tên sản phẩm</th>
                                    <th class="col-sm-1">Giá thị trường</th>
                                    <th class="col-sm-1">Giá bán</th>
                                </tr>
                                <tr ng-repeat="item in elements.matchs track by $index">
                                    <td style="width: 5%">@{{ $index + 1 }}</td>
                                    <td ng-bind="item.id"></td>
                                    <td align="center">
                                        <img ng-src="@{{item.image_url}}" width="100" />
                                    </td>
                                    <td>
                                        <p ng-bind="item.sku"></p>
                                        <div style="display: block">
                                            <a ng-href="@{{item.url}}" target="_blank">@{{ item.name }}</a>
                                        </div>
                                    </td>
                                    <td ng-bind="item.display_high_price"></td>
                                    <td ng-bind="item.display_price"></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('script')
    <script>
        const SEARCH_API_URL = "{{ route('apiSearch') }}";
        const CHECK_IMAGE_URL = "https://similarity-scanner.printerval.com";
        const CURRENT_LOCALE = "{{ env('APP_LOCALE') }}";
    </script>
    <script src="/modules/z-search/controllers/zsearch-duplicate-warning.js?v=<?= time() ?>"></script>
@endsection
