<script>
    var ZSearchRestQOrigin = "{{ config('restq.origin') }}";
    $(document).ready(function () {
        function randomStr(length) {
            var result = '';
            var characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
            var charactersLength = characters.length;
            for (var i = 0; i < length; i++) {
                result += characters.charAt(Math.floor(Math.random() * charactersLength));
            }
            return result;
        }
        function handle() {
            let elements = $('.product-item-box .product-link');
            let items = [];
            let nameHash = {};
            for (let element of elements) {
                let img = $(element).find('img');
                let matches = $(element).attr('href').split('?')[0].match(/\p(\d+)$/);
                let id = 0;
                if (matches && matches.length > 1) {
                    id = matches[1];
                }
                let name = $(element).attr('title').trim().toLowerCase();
                let hash = "";
                if (nameHash[name]) {
                    hash = nameHash[name];
                } else {
                    hash = randomStr(32);
                    nameHash[name] = hash;
                }
                if (img && id) {
                    items.push({
                        id: id,
                        image_url: $(img).attr('src'),
                        name: hash,
                    })
                }
            }
            if (items.length) {
                fetch(`${ZSearchRestQOrigin}/remove-duplicates-search?ignore_localization=1&locale=${localePrefix ? localePrefix : 'us'}`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({ products: items, locale: localePrefix ? localePrefix : 'us', keyword: (new URLSearchParams(window.location.href.split('?')[1])).get('q') })
                })
            }
        }
        handle();
    })
</script>