@extends('system.layout.main', [
'ngController' => 'ZSearchProductPined'
])
@section('title')
    <title>Cấu hình sản phẩm ưu tiên</title>
@endsection

@section('css')
    <style media="screen">
        .header {
            margin-bottom: 25px;
            display: flex;
            justify-content: flex-start;
            align-items: center;
            width: 100%;
        }

        .header .btn-success {
            margin-left: auto;
        }

    </style>
    <style>
        .autocomplete {
            position: relative;
            display: inline-block;
        }

        .autocomplete-items {
            position: absolute;
            width: calc(100% - 30px);
            left: 15px;
            top: 34px;
            z-index: 10;
            background-color: #fff;
            box-shadow: 0 2px 4px rgba(11, 11, 11, 0.3);
            border-radius: 3px;
            max-height: 300px;
            overflow-x: scroll;
        }
    </style>
@endsection

@section('content')

    <div class="content" ng-cloak>
        <div class="header">
            <div class="pull-left list-product-heading">
                <h3 class="heading">Cấu hình sản phẩm ưu tiên</h3>
            </div>
        </div>
        <div class="body" style="min-height: 500px">
            <div class="box no-border">
                <div class="nav-tabs-custom">
                    <ul class="nav nav-tabs hide-xs" style="border-bottom: 0px;">
                        <li class="all-item">
                            <a href="javascript:void(0)">
                                Tạo sản phẩm
                            </a>
                        </li>
                    </ul>
                </div>
                <div class="box-body">
                    @view('system.pined.filter')
                    @view('system.pined.list')
                </div>
            </div>

        </div>
    </div>

@endsection

@section('script')
    <script type="text/javascript">
        var zSearchCdnIgnoreUrl = <?= json_encode(config('cdn.ignore', [])); ?>;
        var zSearchCdnAllowUrl = <?= json_encode(config('cdn.allow', [])); ?>;
    </script>
    <script src="/modules/z-search/controllers/zsearch-product-pined.js?v=<?= time() ?>"></script>
@endsection
