@extends('system.layout.main', [
    'ngController' => 'ZSearchTrackingReport'
])

@section('title')
    <title>Thống kê kết quả tìm kiếm</title>
@endsection

@section('css')
    <style type="text/css">
        #z-search-statistic .list-attribute-statistic {
            margin-left: 20px
        }
        #z-search-statistic .list-attribute-statistic li {
            list-style-type: disc !important;
        }
    </style>
@endsection

@section('script')
    <script src="@asset('z-search/controllers/zsearch-tracking-report.js')?v=<?= Config::get("sa.version") ?>"></script>
@endsection

@section('content')
    <div class="content" id="z-search-statistic">
        <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Từ khóa:</label>
                        <input type="text" class="form-control" ng-model="filter.keyword" ng-keypress="enterEvent($event)" />
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Từ ngày:</label>
                        <input type="text" class="form-control" id="date-from" placeholder="yyyy-mm-dd" />
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Đến ngày:</label>
                        <input type="text" class="form-control" id="date-to" placeholder="yyyy-mm-dd" />
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Sắp xếp:</label>
                        <select class="form-control" ng-model="filter.sortBy" ng-options="item.code as item.name for item in sorts"></select>
                    </div>
                </div>
                <div class="col-md-10">
                    <div class="form-group">
                        <button type="button" class="btn btn-primary" ng-click="pageId = 0; find()"><i class="fa fa-search"></i> Tìm kiếm</button>
                        <button type="button" class="btn btn-default" ng-click="reset()"><i class="fa fa-times"></i> Xóa form</button>
                    </div>
                </div>
            <div class="col-md-2">
                    <div class="form-group" style="float: right">
                        <button class="button btn btn-light flex-b align-c flex-c" ng-click="exportExcel()" >
                            <svg xmlns="http://www.w3.org/2000/svg"
                                 style="margin-right: 5px"
                                 width="12" height="12" fill="currentColor" class="bi bi-download"
                                 viewBox="0 0 16 16">
                                <path d="M.5 9.9a.5.5 0 0 1 .5.5v2.5a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-2.5a.5.5 0 0 1 1 0v2.5a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2v-2.5a.5.5 0 0 1 .5-.5z"/>
                                <path d="M7.646 11.854a.5.5 0 0 0 .708 0l3-3a.5.5 0 0 0-.708-.708L8.5 10.293V1.5a.5.5 0 0 0-1 0v8.793L5.354 8.146a.5.5 0 1 0-.708.708l3 3z"/>
                            </svg>
                            Get Excel
                        </button>
                    </div>
                </div>


            
        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table class="table table-hover" style="background-color: white">
                        <thead>
                            <tr>
                                <th style="width: 5%">STT</th>
                                <th class="col-md-5">Từ khóa</th>
                                <th class="col-md-1">Số lượng</th>
                                <th class="col-md-1">Chuyển đổi</th>
                                <th class="col-md-2">Tỉ lệ chuyển đổi (%)</th>
                                <th style="width: 5%">Thống kê</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr class="list-order-body" ng-repeat="tracking in trackings track by $index">
                                <td>@{{ $index + 1 }}</td>
                                <td>@{{ tracking.keyword }}</td>
                                <td>@{{ tracking.quantity }}</td>
                                <td>@{{ tracking.total_conversion }}</td>
                                <td>@{{ tracking.conversion_rate}}</td>
                                <td class="text-center">
                                    <button type="button" class="btn btn-primary" title="Thống kê màu áo, hình dạng" ng-click="statisticPrototype(tracking)">&nbsp;<i class="fa fa-pie-chart" aria-hidden="true"></i>&nbsp;</button>
                                </td>
                            </tr>
                            <tr ng-if="trackings.length == 0">
                                <td colspan="6">
                                    <div style="font-size: 15px">
                                        Không tìm thấy dữ liệu tìm kiếm này. <span ng-if="filter.keyword && filter.keyword != ''">Nhưng bạn vẫn có thể xem <b>Thống kê Màu áo, hình dạng đang được ưa chuộng</b> bằng cách nhấn <a href="javascript:void(0)" style="font-weight: bold" ng-click="searchStatistic()">vào đây</a>.</span>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            @include('z-search::includes.paginator', [
                "accessPageId" => "filter.pageId",
                "accessPagesCount" => "pagesCount",
                "accessFind" => "find()"
            ])
        </div>
        @include('z-search::tracking.statistic')
    </div>
@endsection