<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */
Route::get('/search', 'HomeController@index')->name('search')->middleware('frontend');
Route::get('/search/trending', 'HomeController@trending')->name('trending')->middleware('frontend');
Route::get('/search/suggest', 'HomeController@suggestion')->name('suggestion')->middleware('frontend');
Route::get('/search/api', 'HomeController@apiSearch')->name('apiSearch')->middleware('frontend');
Route::post('/search/tracking-keyword', 'HomeController@searchTracking')->middleware('bot.default_response')->name('tracking');
// Route::get('/explore/{tagTitle}', 'HomeController@index')
//     ->name('tag::explore')
//     ->where('tagTitle', '[0-9a-zA-Z/_\-]+')
//     ->middleware('frontend');
// Route::get('/{slug}-t{id}.html', 'HomeController@index')
//     ->name('tag')->where('slug', '[0-9a-zA-Z/_\-]+')
//     ->where('id', '[0-9]+')
//     ->middleware('frontend');

Route::get('/merch/{keyword}', 'HomeController@index')
    ->name('merch')
    ->middleware('frontend');

Route::group(['prefix' => 'z-search'], function () {
    Route::get('/', [
        'as' => 'z-search::home',
        'uses' => 'HomeController@index',
    ]);
    Route::get('/init', [
        'as' => 'z-search::init',
        'uses' => 'HomeController@init',
    ]);

    Route::get('/index-new-product', [
        'as' => 'z-search::init-new-product',
        'uses' => 'IndexController@indexNewProduct',
    ]);

    Route::get('/index-new-product-seller', [
        'as' => 'z-search::init-new-product-seller',
        'uses' => 'IndexController@indexSeller',
    ]);

    Route::get('/index-by-range', [
        'as' => 'z-search::init-by-range',
        'uses' => 'IndexController@indexByRange',
    ]);

    Route::get('/index-option-by-range', [
        'as' => 'z-search::init-option-by-range',
        'uses' => 'IndexController@indexOptionByRange',
    ]);

    Route::get('/index-sku-by-range', [
        'as' => 'z-search::init-sku-by-range',
        'uses' => 'IndexController@indexSkuByRange',
    ]);

    Route::get('/index-product-custom', [
        'as' => 'z-search::index-product-custom',
        'uses' => 'IndexController@indexProductCustom',
    ]);

    Route::get('/warning-els-index', [
        'as' => 'z-search::warning',
        'uses' => 'HomeController@warningElsIndex',
    ]);

    Route::get('/update-price', [
        'as' => 'z-search::update-price',
        'uses' => 'HomeController@updatePrice',
    ]);

    Route::get('/handle-hidden-product', [
        'as' => 'z-search::handleHiddenProduct',
        'uses' => 'HomeController@handleHiddenProduct',
    ]);

    Route::post('/position', [
        'as' => 'z-search::position',
        'uses' => 'HomeController@position',
    ]);

    Route::get('/amazon-search', [
        'as' => 'z-search::amazonSearch',
        'uses' => 'CrawlController@amazonSearch',
    ]);
    Route::get('/cron-react', [
        'as' => 'z-search::cron-react',
        'uses' => 'SearchReactController@cronKeywordReact',
    ]);
    Route::post('/cron-home-tags', [
        'as' => 'z-search::cron-home-tags',
        'uses' => 'SearchReactController@cronHomeTags',
    ]);
    Route::get('/build-keyword-tracking', [
        'as' => 'z-search::cronBuildKeywordTracking',
        'uses' => 'SearchReactController@cronBuildKeywordTracking',
    ]);
    Route::get('/cron-mapping-keyword', [
        'as' => 'z-search::cron-mapping-keyword',
        'uses' => 'MappingOrderSearch@cron',
    ]);
    Route::get('/amazon-crawl-product', [
        'as' => 'z-search::amazonCrawlProduct',
        'uses' => 'CrawlController@amazonCrawlProduct',
    ]);

    Route::post('/amz-crawl-multi-product', [
        'as' => 'z-search::amazonCrawlMultiProduct',
        'uses' => 'CrawlController@amazonCrawlMultiProduct',
    ]);

    Route::get('/index-payment-stat', [
        'as' => 'z-search::indexPaymentStat',
        'uses' => 'HomeController@indexPaymentStat',
    ]);

    Route::get('/index-product-stat', [
        'as' => 'z-search::indexProductStat',
        'uses' => 'RebuildController@indexProductStat',
    ]);

    Route::get('/index-product-sale', [
        'as' => 'z-search::indexProductSale',
        'uses' => 'RebuildController@indexProductSale',
    ]);

    Route::get('/index-from-queue', [
        'as' => 'z-search::indexFromQueue',
        'uses' => 'HomeController@indexFromQueue',
    ]);
    Route::get('/suggest/cron', [
        'as' => 'z-search::suggest-data:cron',
        'uses' => 'SuggestController@cronBuildData',
    ]);
    Route::get('/suggest/find', [
        'as' => 'z-search::suggest-data:find',
        'uses' => 'SuggestController@find',
    ]);
    Route::get('/suggest/init', [
        'as' => 'z-search::suggest-data:init',
        'uses' => 'SuggestController@multiIndex',
    ]);
    Route::get('/seller/index-by-seller', [
        'as' => 'z-search::seller::indexBySeller',
        'uses' => 'SellerController@indexBySeller',
    ]);
    Route::get('/seller/index', [
        'as' => 'z-search::seller::index',
        'uses' => 'SellerController@index',
    ]);
    Route::post('/seller/index', [
        'as' => 'z-search::seller::post-index',
        'uses' => 'SellerController@index',
    ]);
    Route::get('/seller/search', [
        'as' => 'z-search::seller::search',
        'uses' => 'SellerController@search',
    ]);
    Route::get('/trademark/index', [
        'as' => 'z-search::trademark::index',
        'uses' => 'TrademarkController@index',
    ]);
    Route::get('/trademark/search', [
        'as' => 'z-search::trademark::search',
        'uses' => 'TrademarkController@search',
    ]);
    Route::get('/trademark-keyword/index', [
        'as' => 'z-search::trademark-keyword::index',
        'uses' => 'TrademarkKeywordController@index',
    ]);
    Route::post('/trademark-keyword/test', [
        'as' => 'z-search::trademark-keyword::test',
        'uses' => 'TrademarkKeywordController@importExcel',
    ]);
    Route::any('/trademark-keyword/check', [
        'as' => 'z-search::trademark-keyword::check',
        'uses' => 'TrademarkKeywordController@check',
    ]);
    Route::get('/trademark-keyword/delete-all-record', [
        'as' => 'z-search::trademark-keyword::removeAllRecords',
        'uses' => 'TrademarkKeywordController@removeAllRecords',
    ]);

    Route::post('/ignore-product/store', [
        'as' => 'z-search::ignore-product::store',
        'uses' => 'IgnoreProductController@store',
    ]);
    Route::post('/ignore-product/store-duplicated', [
        'as' => 'z-search::ignore-product::store-duplicated',
        'uses' => 'IgnoreProductController@storeIgnoreDuplicated',
    ]);
    Route::get('/ignore-product/rebuild', [
        'as' => 'z-search::ignore-product::deleteByUpdated',
        'uses' => 'IgnoreProductController@deleteByUpdated',
    ]);

    Route::get('/ignore-product/rebuild-all', [
        'as' => 'z-search::ignore-product::rebuildAllProductIgnore',
        'uses' => 'IgnoreProductController@rebuildAllProductIgnore',
    ]);
//    Route::get('/rebuild/duplicate-design', [
//        'as' => 'z-search::rebuild::duplicate-design',
//        'uses' => 'RebuildController@duplicateDesign',
//    ]);

//    Route::get('/rebuild/update-seller', [
//        'as' => 'z-search::rebuild::update-seller',
//        'uses' => 'RebuildController@updateSeller',
//    ]);

    Route::get('/rebuild/update-multi-column', [
        'as' => 'z-search::rebuild::update-multi-column',
        'uses' => 'RebuildController@updateMultiColumn',
    ]);

    Route::get('/rebuild/update-multi-product-trademark', [
        'as' => 'z-search::rebuild::update-multi-product-trademark',
        'uses' => 'RebuildController@updateMultiProductTradeMark',
    ]);

    Route::get('/rebuild/update-payment-stat', [
        'as' => 'z-search::rebuild::updatePaymentStat',
        'uses' => 'RebuildController@updatePaymentStat',
    ]);

    Route::get('/rebuild/rebuildSearchTracking', [
        'as' => 'z-search::rebuild::rebuildSearchTracking',
        'uses' => 'RebuildController@rebuildSearchTracking',
    ]);

    Route::get('/search-variant-option', [
        'as' => 'z-search::search-variant-option',
        'uses' => 'ApiController@searchVariantOptions',
    ]);
    Route::get('/search-by-categories', [
        'as' => 'z-search::searchByCategoryIds',
        'uses' => 'ApiController@searchByCategories',
    ]);

    Route::get('/small_designs/init-old', ['uses' => 'SmallDesignController@multiIndexDesign']);
    Route::get('/small_designs/index-by-id', ['uses' => 'SmallDesignController@indexDesignById']);
    Route::get('/small_designs/find', ['uses' => 'SmallDesignController@searchDesign'])->middleware('zsearch_cors');
    Route::get('/small_designs/image-search-find', ['uses' => 'SmallDesignController@searchDesignImageSearch'])->middleware('zsearch_cors');
    Route::get('/small_designs/init', ['uses' => 'SmallDesignController@indexSmallDesign']);
    Route::get('/small_designs/index-seller', ['uses' => 'SmallDesignController@indexSeller']);
    Route::any('/build-tag-schema', ['uses' => 'HomeController@buildTagSchema']);
    Route::any('/make-tag-meta-schema', ['uses' => 'HomeController@makeTagMeta']);
    Route::any('/build-trending-related-tags', ['uses' => 'HomeController@buildTrendingRelatedTags']);
    Route::any('/build-product-trending-related-tags', ['uses' => 'HomeController@buildProductTrendingRelatedTags']);
    Route::get('/tag/init', ['uses' => 'TagController@index']);
    Route::get('/tag/find', ['uses' => 'TagController@search']);
    Route::get('/tag/init-by-id', ['uses' => 'TagController@indexById']);
    Route::post('/mapping-keyword/store', ['as' => 'z-search::post::mappingKeyword', 'uses' => 'MappingKeywordController@store']);
    Route::get('/mapping-keyword/find', ['as' => 'z-search::get::mappingKeyword', 'uses' => 'MappingKeywordController@find']);
    Route::get('/category/init', ['uses' => 'CategoryController@createIndexType']);
    Route::get('/category/create-type', ['uses' => 'CategoryController@createType']);
    Route::get('/category/reindex', ['uses' => 'CategoryController@reindex']);
    Route::get('/category/index-name', ['uses' => 'CategoryController@checkIndexName']);
    Route::get('/category/compare', [
        'as' => 'z-search::compareCategory',
        'uses' => 'CategoryController@compareCategory',
    ]);
    Route::get('/category/index-new-product', ['uses' => 'CategoryController@indexNewProduct']);
    Route::get('/build-product-stat', ['uses' => 'CategoryController@buildProductStat']);
    Route::get('/z-search-explore/{tagTitle}', ['uses' => 'ExploreController@exploreTag']);
    Route::get('/index-tag', ['uses' => 'RebuildController@indexTag']);
    Route::get('/build-best-selling-option', ['uses' => 'ExploreController@buildBestSellingByCategory']);
    Route::get('/z-search-product-by-tag',  ['uses' => 'ExploreController@filterProductByTag']);
    Route::get('/product/index', ['as' => 'z-search::product::index', 'uses' => 'ProductController@index']);
    Route::get('/product/init', ['as' => 'z-search::product::init', 'uses' => 'ProductController@init']);
    Route::get('/product/search', ['as' => 'z-search::product::search', 'uses' => 'ProductController@search']);
    Route::get('/index-detail-product', [
        'as' => 'z-search::index-detail-product',
        'uses' => 'ProductDetailController@buildDetailProduct',
    ]);
    Route::get('/syncElasticsearchProductIndex', [
        'as' => 'z-search::syncElasticsearchProductIndex',
        'uses' => 'ProductDetailController@syncElasticsearchProductIndex',
    ]);
    Route::get('/updateFlashSale', [
        'as' => 'z-search::updateFlashSale',
        'uses' => 'ProductDetailController@updateFlashSale',
    ]);
    Route::get('/report/score', ['as' => 'z-search::report::score', 'uses' => 'ReportScoreController@score']);
    Route::get('/report/keywords', ['as' => 'z-search::report::keywords', 'uses' => 'ReportScoreController@keywordStatistic']);

});

$authMiddleware = config('app.system_auth_middleware');
Route::group(['prefix' => 'z-search', 'middleware' => $authMiddleware], function () {
    Route::get('/pined', ['as' => 'z-search::config', 'uses' => 'ConfigController@index']);
    Route::get('/report', ['as' => 'z-search::report', 'uses' => 'TrackingController@report']);
    Route::get('/duplicate-warning', ['as' => 'z-search::duplicate-warning', 'uses' => 'ConfigController@duplicateWarning']);
    Route::get('/tracking/find', ['as' => 'z-search::tracking::find', 'uses' => 'TrackingController@find']);
    Route::get('/tracking/export', ['as' => 'z-search::tracking::export', 'uses' => 'TrackingController@export']);
    Route::get('/report/statistic', ['as' => 'z-search::report::statistic', 'uses' => 'ReportKeywordController@statisticFromTracking']);
    Route::get('/report/statistic-search-data', ['as' => 'z-search::report::statistic-search-data', 'uses' => 'ReportKeywordController@statisticFromSearchData']);
    Route::get('/report/suggest-keyword', ['as' => 'z-search::report::suggestKeyword', 'uses' => 'ReportKeywordController@suggestKeyword']);
   
});

Route::group(['prefix' => 'z-search', 'middleware' => ['auth']], function () {
    Route::get('/react/find', ['as' => 'z-search::react::find', 'uses' => 'SearchReactController@find']);
});



