<?php
/**
 * Created by PhpStorm.
 * User: DiemND
 * Date: 5/26/21
 * Time: 3:11 PM
 */

namespace Modules\ZSearch\Services;

use Illuminate\Support\Facades\Input;

include_once '../app/Modules/ZSearch/Helpers/simple_html_dom.php';

class AmazonService
{
    public function crawlSearch ($keyword) {
        $retVal = [];
        $context = $this->getContext();
        $urlSearch = 'https://www.amazon.com/s?' . http_build_query(['k' => $keyword]);
        $htmlSearch = file_get_html($urlSearch, false, $context);
        $elementSearchs = $htmlSearch->find('div[data-component-type=s-search-result]');
        foreach ($elementSearchs as $key => $elementSearch) {
            $price = $this->getPrice($elementSearch);
            $item = [
                'id' => -1,
                'sku' => 'AMAZON ' . $key,
                'image_url' => $this->getImage($elementSearch),
                'name' => $this->getName($elementSearch),
                'url' => $this->getUrl($elementSearch),
                'price' => $price,
                'high_price' => $price,
                'display_price' => formatPrice(doubleval($price)),
                'view_count' => 0,
                'sold' => 0,
                'inventory' => 0,
                'brand_id' => 1,
            ];
            $retVal[] = $item;
        }
        return $retVal;
    }

    private function getImage ($element) {
        $retVal = '';
        $elementImg = $element->find('img.s-image', 0);
        if ($elementImg) {
            $url = $elementImg->src;
            $arr = explode('.', $url);
            unset($arr[count($arr) -2]);
            $retVal = implode('.', $arr);
        }
        return $retVal;
    }

    private function getName ($element) {
        $retVal = '';
        $elm = $element->find('h2 a span', 0);
        if ($elm) {
            $retVal = $elm->plaintext;
        }
        $retVal = $retVal = trim($retVal);;
        return htmlspecialchars_decode($retVal);
    }
    private function getUrl ($element) {
        $retVal = '';
        $elm = $element->find('h2 a', 0);
        if ($elm) {
            $retVal = 'https://amazon.com' . $elm->href;
        }
        return $retVal;
    }

    private function getPrice ($element) {
        $retVal = '';
        $elm = $element->find('.a-price .a-offscreen', 0);
        if ($elm) {
            $retVal = trim($elm->plaintext);
            $retVal = str_replace('$', '', $retVal);
            $retVal = floatval($retVal);
        }
        return $retVal;
    }

    private function getSponsored ($element) {
        $retVal = 0;
        $elm = $element->find('span.a-declarative a .s-label-popover-default .a-color-secondary', 0);
        if ($elm) {
            $text = trim($elm->plaintext);
            if ($text == 'Sponsored') {
                $retVal = 1;
            }
        }
        return $retVal;
    }

    private function getContext () {
        $countryCode = Input::get('country_code', 'us');
        $configProxy = config('z-search::sa.proxy');
        $context = [];
        if ($configProxy) {
            $proxy = isset($configProxy[$countryCode]) ? $configProxy[$countryCode] : $configProxy['us'];
            $auth = base64_encode($proxy['username'] . ':' . $proxy['password']);
            $context = array(
                'http'=>array(
                    'method' => 'GET',
                    'proxy'           => $proxy['url'],
                    'request_fulluri' => true,
                    'header'          => "Proxy-Authorization: Basic $auth"
                )
            );
        }
        return $context;
    }


}

