<?php

namespace Modules\ZSearch\Services;

use Illuminate\Support\Facades\DB;
use Modules\ZSearch\Models\Product;
use Modules\ZSearch\Models\Category;
use Illuminate\Support\Facades\Schema;
use Modules\ZSearch\Models\ProductNCategoryTop;

class ElasticSearchIndexCategory extends ElasticSearchIndex
{
    const TYPE_PRODUCT_N_CATEGORY_TOP = 'product_n_category_top';
    private $configIndexKey = 'category_index';

    public function __construct()
    {
        parent::__construct();
    }

    public function multiIndexProductNCategory($filter, $elasticsearchConfig) {
        $start = time();
        $categoryIds = $this->getAllCategoryIds();
        $count = 0;
        $error = [];
        foreach ($categoryIds as $item) {
            if (isset($filter['category_id']) && $filter['category_id'] > 0 && $filter['category_id'] != $item) {
                continue;
            }
            $productIds = $this->getProductIdsByCategoryId($item);
            \Log::info('ZSEARCH - multiIndexProductNCategory count', [count($productIds)]);
            if ($productIds) {
                foreach (array_chunk($productIds, 200) as $partProductIds) {
                    \Log::info('ZSEARCH - multiIndexProductNCategory pids', $partProductIds);
                    $count += count($partProductIds);
                    $products = $this->getProductsNCategory(array_merge($filter, [
                        'type' => 'init',
                        'ids' => $partProductIds
                    ]))->toArray();
                    if (Schema::hasTable('product_stat')) {
                        $this->buildProductStat($partProductIds);
                    }
                    $data = $this->indexMainProducts($products, self::TYPE_PRODUCT_N_CATEGORY_TOP, $elasticsearchConfig[$this->configIndexKey]);
                    if ($data['error']) {
                        \Log::error('ZSEARCH - multiIndexProduct ERROR', [$data['error']]);
                        $error[] = $data['error'];
                    }
                }
            }
        }

        return [
            'count' => $count,
            'error' => $error,
            'runtime' => time() - $start,

        ];
    }

    public function indexNewProduct($elasticsearchConfig) {
        $start = time();
        $categoryIds = $this->getAllCategoryIds();
        $count = 0;
        $error = [];
        foreach ($categoryIds as $item) {
            $productIds = $this->getProductIdsByCategoryId($item);
            \Log::info('ZSEARCH - multiIndexProductNCategory count', [count($productIds)]);
            if ($productIds) {
                foreach (array_chunk($productIds, 200) as $partProductIds) {
                    $query = [
                        'query' => [
                            'terms' => [
                                'id' => $partProductIds
                            ]
                        ],
                        'size' => 200
                    ];
                    $response = $this->elasticService->searchDocument($query, self::TYPE_PRODUCT_N_CATEGORY_TOP, $elasticsearchConfig[$this->configIndexKey]);
                    $idsFromEls = [];
                    foreach ($response['hits']['hits'] as $productItem) {
                        $idsFromEls[] = $productItem['_source']['id'];
                    }
                    $newIds = array_diff($partProductIds, $idsFromEls);
                    if (empty($newIds)) {
                        continue;
                    }
                    \Log::info('ZSEARCH - multiIndexProductNCategory pids', $newIds);
                    $products = $this->getProductsNCategory([
                        'type' => 'init',
                        'ids' => $newIds,
                        'is_all' => 1
                    ])->toArray();
                    $count += count($products);
                    if (Schema::hasTable('product_stat')) {
                        $this->buildProductStat($newIds);
                    }
                    $data = $this->indexMainProducts($products, self::TYPE_PRODUCT_N_CATEGORY_TOP, $elasticsearchConfig[$this->configIndexKey]);
                    if ($data['error']) {
                        \Log::error('ZSEARCH - multiIndexProduct ERROR', [$data['error']]);
                        $error[] = $data['error'];
                    }
                }
            }
        }

        return [
            'count' => $count,
            'error' => $error,
            'runtime' => time() - $start,

        ];
    }

    protected function getAllCategoryIds() {
        return Category::getAllIds();
    }

    protected function getProductIdsByCategoryId($categoryId) {
        return ProductNCategoryTop::getProductIds($categoryId);
    }

    protected function getProductsNCategory($filter = [], $customColumns = []) {
        $query = Product::getProductNCategoryQuery($filter);
        $columns = [
            'product.id as id', 'sku', 'name', 'slug', 'image_url', 'brand_id',
            'status', 'price', 'high_price', 'inventory', 'view_count', 'sold',
            'pnct.category_id as category_id', 'pnct.id as product_n_category_top_id', 'product.created_at as product_created_at',
            'rating_count', 'rating_value', 'horder'
        ];
        $columns = $customColumns ? array_merge($columns, $customColumns) : $columns;
        return $query->get($columns);
    }
}
