<?php

namespace Modules\ZSearch\Services;


use Illuminate\Support\Facades\DB;

class ElasticsearchIndexHistory
{
    public static function logHistory($startTime, $data)
    {
        if (ElasticSearchIndex::tableExists('zsearch_index_history')) {
            DB::table('zsearch_index_history')->insert([
                'data' => json_encode($data),
                'started_at' => date('Y-m-d H:i:s', $startTime),
                'created_at' => new \DateTime(),
            ]);
        }
    }


    public function warning($filter)
    {
        $items = $this->buildQuery($filter)
            ->orderBy('started_at', 'asc')
            ->get();
        $result = [];
        $intervalTime = isset($filter['interval_time']) ?  $filter['interval_time'] : 30 * 60;
        for ($i = 1; $i < count($items); $i++) {
            $lastTime = strtotime($items[$i - 1]->started_at);
            $currentTime = strtotime($items[$i]->started_at);
            if ($currentTime - $lastTime > $intervalTime) {
                $result[] = date('Y-m-d H:i:s', $currentTime - $intervalTime);
            }
        }
        return $result;
    }

    protected function buildQuery($filter)
    {
        $query = DB::table('zsearch_index_history');
        if (array_key_exists('from_time', $filter)) {
            $query->where('started_at', '>=', $filter['from_time']);
        }
        if (array_key_exists('to_time', $filter)) {
            $query->where('started_at', '<=', $filter['to_time']);
        }
        return $query;

    }
}