<?php

namespace Modules\ZSearch\Services;

use Illuminate\Support\Facades\DB;

class EtsyDataDecor
{
    public function decor($products) {
        return $this->buildEtsyProduct($products);
    }

    public function buildEtsyProduct($items)
    {
        $result = [];
        foreach ($items as $item) {
            $item['slug'] = str_slug($item['name']);
            $code = $item['code'];
            $slug = str_slug($item['name']);
            $insertData = [
                'sku' => $code,
                'image_url' => $item['image_url'],
                'name' => $item['name'],
                'slug' => $slug,
                'price' => $item['price'],
                'high_price' => $item['price'],
                'view_count' => 0,
                'sold' => 0,
                'inventory' => 0,
                'brand_id' => 1,
            ];
            
            $record = DB::table('product')->where('slug', $slug)->select(['id', 'slug'])->first();
            $insertData['display_price'] = formatPrice(doubleval($item['price']));
            $insertData['crawl_url'] = $item['url'];
            if ($record) {
                $insertData['url'] = str_replace(config('app.url'), '', route('product', ['slug' => $record->slug,'id' => $record->id]));
            } else {
                $insertData['url'] = null;
            }

            $insertData['product_id'] = $item['product_id'];

            $result[] = $insertData;
        }
        
        return $result;
    }

    private function buildProductMetaKey($site = 'etsy') {
        return $site . '_crawl_code';
    }

    private function insertOrUpdateProduct($data, $site = 'etsy') {
        //@todo build key meta
        $key = $this->buildProductMetaKey($site);
        $code = $data['sku'];
        $p = DB::table('product')
            ->where('slug', $data['slug'])
            ->first(['id']);
        if ($p && isset($p->id)) {
            $pId = $p->id;
        } else {
            $pId = DB::table('product')->insertGetId($data);
            DB::table('product_meta')->insert([
                'product_id' => $pId,
                'value' => $code,
                'key' => $key,
            ]);
        }
        return $pId;
    }

    protected function mergeEtsyData($scoreGroup, $etsyItems, $filter) {
        $pageSize = isset($filter['page_size']) ? $filter['page_size'] : 60;
        $lowItems = $scoreGroup['lowScoreItems'];
        array_splice($scoreGroup['highScoreItems'], 10, 0, $etsyItems);
        $result = $scoreGroup['highScoreItems'];
        if (count($result) < $pageSize && $lowItems) {
            $result = array_merge($result, $scoreGroup['lowScoreItems']);
        }

        return $result;
    }

    protected function getScoreGroup($items) {
        $highScoreItems = [];
        $lowScoreItems = [];
        foreach ($items as $item) {
            if ($this->isHighScore($item)) {
                $highScoreItems[] = $item;
            } else {
                $lowScoreItems[] = $item;
            }
        }
        return [
            'highScoreItems' => $highScoreItems,
            'lowScoreItems' => $lowScoreItems,
        ];
    }

    protected function isHighScore($item) {
        $result = false;
        $highScoreFrom =  config('z-search::etsy.high_score_from', 5);
        $score = isset($item['_score']) ? $item['_score'] : 0;
        $zStatus = array_key_exists('zstatus', $item) ? $item['zstatus'] : null;
        $enableZStatus = [
            SearchDataDecor::STATUS_CONTAINS,
            SearchDataDecor::STATUS_POSITION,
            SearchDataDecor::STATUS_PINED,
        ];
        $statusIsOk = $zStatus && in_array($zStatus, $enableZStatus);
        $scoreIsOk = $score >= $highScoreFrom;
        if ($scoreIsOk || $statusIsOk) {
            $result = true;
        }
        return $result;
    }

    public function calculatorKeyword($items, $filter) {
        $keyword = $filter['origin_keyword'];
        if ($filter['origin_keyword']  == $filter['keyword']) {
            $categoryName = $this->getCategoryNameFromResult($items);
            if ($categoryName) {
                $keyword .= ' ' . $categoryName;
            }
        }
        return strtolower($keyword);

    }

    protected function getCategoryNameFromResult($items) {
        $statisticData = [];
        $categoryName = '';
        foreach ($items as $item) {
            if (!isset($item['categories']) || !is_array($item['categories']) || !$item['categories']) {
                continue;
            }
            if (!isset($item['categories'][count($item['categories']) - 1])) {
                continue;
            }
            $category = $item['categories'][count($item['categories']) - 1];
            $categoryId = $category['id'];
            $name = $category['name'];
            if (!array_key_exists($categoryId, $statisticData)) {
                $statisticData[$categoryId] = [
                    'name' => $name,
                    'count' => 0,
                ];
            }
            $statisticData[$categoryId]['count']++;

        }
        if ($statisticData) {
            usort($statisticData, function($a, $b) {
                $countA = isset($a['count'])  ? $a['count'] : 0;
                $countB = isset($b['count'])  ? $b['count'] : 0;
                return $countA < $countB;
            });
            $categoryName = isset($statisticData[0]['name']) ? $statisticData[0]['name'] : '';
        }
        if ($categoryName) {
            $categoryName = str_replace('-', ' ', $categoryName);
        } else {
            $categoryName = 't shirt';
        }
        return $categoryName;
    }
}

?>