<?php

namespace Modules\ZSearch\Services;

use Illuminate\Support\Facades\DB;

class SuggestDataService
{

    public function suggest($filter) {
        return $this->searchSuggestQuery($filter)
            ->orderBy('conversion', 'desc')
            ->limit($filter['limit'])
            ->get(['keyword']);
    }

    public function findTrending($filter) {
        return $this->searchSuggestQuery($filter)
            ->orderBy('search', 'desc')
            ->orderBy('conversion', 'desc')
            ->limit($filter['limit'])
            ->get(['keyword']);
    }

    public function getSearchTrackingData($filter) {
        $query = $this->searchTrackingQuery($filter);
        $result = $query->groupBy('keyword')->get([
            DB::raw('SUM(quantity) as quantity'),
            DB::raw('SUM(conversion) as conversion'),
            'keyword',
        ])->toArray();
        return $result;
    }

    public function store($data) {
        DB::table('search_suggest')->where('keyword', $data['keyword'])->delete();
        DB::table('search_suggest')->insert($data);
    }

    public function delete($toDate) {
        $this->searchSuggestQuery(['to_date' => $toDate])->delete();
    }

    protected function searchSuggestQuery($filter) {
        $query = DB::table('search_suggest');
        if (array_key_exists('from_date', $filter)) {
            $query->where('created_at', '>=', $filter['from_date']);
        }
        if (array_key_exists('to_date', $filter)) {
            $query->where('created_at', '<', $filter['to_date']);
        }
        if (array_key_exists('keyword', $filter)) {
            $query->where('keyword', 'like', $filter['keyword'] . '%');
        }
        return $query;
    }

    protected function searchTrackingQuery($filter) {
        $query = DB::table('search_tracking');
        if (array_key_exists('from_date', $filter)) {
            $query->where('created_at', '>=', $filter['from_date']);
        }
        return $query;
    }

    public function insertAll($data) {
        $insertArrays = array_chunk($data, 5000);
        foreach ($insertArrays as $insertArray) {
            DB::table('search_suggest')->insert($insertArray);
        }
    }

    public function getCurrentMinId() {
        $result = DB::table('search_suggest')->min('id');
        return $result ? $result : 0;
    }

}

