<?php

namespace Modules\ZSearch\Services;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class TagService
{
    protected $META_RELATED = 'related_trending_tag';
    public function __construct()
    {
        
    }

    public function getTagData($data, $tagTitle)
    {
        $tags = [];

        if (isset($data['dispatches_attrs']['tag'])) {
            try {
                $tags = DB::table('tag_trending_related')
                    ->join('tag', 'tag.id', 'tag_trending_related.related_tag_id')
                    ->where('tag_trending_related.tag_id', $data['dispatches_attrs']['tag']['id'])
                    ->select('tag.*')
                    ->orderBy('tag_trending_related.id', 'desc')
                    ->limit(20)
                    ->get()
                    ->toArray();

                if (isset($data['category_id'])) {
                    
                    $category = DB::table('category')->where('id', $data['category_id'])
                        ->select(['name'])
                        ->first();

                    $tags = array_map(function($tag) use ($category) 
                    {
                        $tag = get_object_vars($tag);
                        if ($category && $category->name) {
                            $tag['title'] .= ' ' . $category->name;
                        }
                        return $tag;
                    }, $tags);

                } else {
                    $tags = array_map(function($tag) {
                        $tag = get_object_vars($tag);
                        return $tag;
                    }, $tags);
                }

            } catch (\Exception $ex) {
                Log::error("Get tag data fail, " . $ex->getMessage());
            }
        }
         
        return $tags;
    }

    public function buildTrendingRelatedTags()
    {
        ini_set('memory_limit', '1024M');
        set_time_limit(1800);

        $perPage = 1000;
        $maxId = DB::table('tag')->max('id');
        $pageCount = ceil($maxId / $perPage);
        $insertCount = 0;

        $trendingTags = $this->getTrendingTags();

        if ($trendingTags) 
        {
            for ($i = 0; $i < $pageCount; $i ++) {
                $start = $i * $perPage;
                $stop = $start + $perPage;
    
                $tags = DB::table('tag')->select(['id', 'title'])
                    ->where('id', '>=', $start)
                    ->where('id', '<', $stop)
                    ->get();
    
                $insertData = [];
    
                foreach ($tags as $tag) {
    
                    $keys = array_rand($trendingTags, 20);
                    for ($j = 0; $j < 20; $j++) { 
    
                        $relatedTag = $trendingTags[$keys[$j]];
    
                        $date = date('Y-m-d H:i:s');
    
                        $insertData[] = [
                            'tag_id' => $tag->id,
                            'related_tag_id' => $relatedTag->id,
                            'created_at' => $date
                        ];
    
                    }
    
                }
    
                DB::table('tag_trending_related')->insert($insertData);
                $insertCount += count($insertData);
            }
        }

        return $insertCount;
    }

    public function buildProductTrendingRelatedTags()
    {
        ini_set('memory_limit', '1024M');
        set_time_limit(1800);

        $perPage = 1000;
        $maxId = DB::table('product')->max('id');
        $pageCount = ceil($maxId / $perPage);
        $insertCount = 0;

        $trendingTags = $this->getTrendingTags();

        if ($trendingTags) 
        {
            for ($i = 0; $i < $pageCount; $i ++) {
                $start = $i * $perPage;
                $stop = $start + $perPage;
    
                $products = DB::table('product')->select(['id'])
                    ->where('id', '>=', $start)
                    ->where('id', '<', $stop)
                    ->where('sold', '!=', 0)
                    ->get();
    
                $insertData = [];
    
                foreach ($products as $product) {
    
                    $keys = array_rand($trendingTags, 20);
                    for ($j = 0; $j < 20; $j++) { 
    
                        $relatedTag = $trendingTags[$keys[$j]];
    
                        $date = date('Y-m-d H:i:s');
    
                        $insertData[] = [
                            'product_id' => $product->id,
                            'related_tag_id' => $relatedTag->id,
                            'created_at' => $date
                        ];
    
                    }
    
                }
    
                DB::table('product_tag_trending_related')->insert($insertData);
                $insertCount += count($insertData);
            }
        }

        return $insertCount;
    }

    protected function getTrendingTags()
    {
        // $weekStartAt = DB::table('trending_tag')->latest('id')->first();
        $weekStartAt = Carbon::now()->subDays(30);
        
        return DB::table('trending_tag')
            ->orderBy('id', 'desc')    
            ->select(['tag_id as id', 'tag_name as title', 'tag_slug as slug'])
            ->where('week_started_at', '>=', $weekStartAt->format('Y-m-d H:i:s'))
            ->groupBy('tag_id')
            ->get()
            ->toArray();
    }
}